/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.item;

import gloridifice.watersource.common.capability.WaterLevelCapability;
import gloridifice.watersource.registry.GroupRegistry;
import gloridifice.watersource.registry.ItemRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class WaterBagItem
extends ItemFluidContainer {
    boolean canDrink = false;
    boolean canFill = false;
    final int unit;

    public WaterBagItem(String name, int capacity, int unit) {
        super(new Item.Properties().func_200917_a(1).setNoRepair().func_200918_c(capacity).func_200916_a(GroupRegistry.waterSourceGroup), capacity);
        this.unit = unit;
        this.setRegistryName(name);
    }

    public int func_77626_a(ItemStack stack) {
        return this.canDrink ? 40 : 0;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return this.canDrink ? UseAction.DRINK : UseAction.NONE;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(data -> data.drain(this.unit, IFluidHandler.FluidAction.EXECUTE));
        this.updateDamage(stack);
        return stack;
    }

    public void updateDamage(ItemStack stack) {
        stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(data -> {
            int i = this.capacity - data.getFluidInTank(0).getAmount() >= 0 ? this.capacity - data.getFluidInTank(0).getAmount() : 0;
            stack.func_196085_b(i);
        });
    }

    public int getUnit() {
        return this.unit;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        this.updateDamage(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        this.canFill = false;
        BlockRayTraceResult raytraceresult = WaterBagItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            playerIn.func_184598_c(handIn);
            return this.canDrink(playerIn, playerIn.func_184586_b(handIn)) ? ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn)) : ActionResult.func_226251_d_((Object)playerIn.func_184586_b(handIn));
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_216350_a();
            if (worldIn.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) {
                itemstack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(data -> {
                    if (data.getFluidInTank(0).isEmpty() || data.getFluidInTank(0).getFluid() == Fluids.field_204546_a) {
                        this.canFill = true;
                    }
                });
                if (this.canFill) {
                    worldIn.func_184148_a(playerIn, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    itemstack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(data -> data.fill(new FluidStack((Fluid)Fluids.field_204546_a, data.getTankCapacity(0)), IFluidHandler.FluidAction.EXECUTE));
                    return ActionResult.func_226248_a_((Object)itemstack);
                }
            }
            playerIn.func_184598_c(handIn);
            return this.canDrink(playerIn, playerIn.func_184586_b(handIn)) ? ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn)) : ActionResult.func_226251_d_((Object)playerIn.func_184586_b(handIn));
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            stack.func_196085_b(this.capacity);
            items.add((Object)stack);
        }
    }

    public boolean canDrink(PlayerEntity playerIn, ItemStack stack) {
        this.canDrink = false;
        if (this.getDamage(stack) <= this.getMaxDamage(stack) - this.getUnit()) {
            playerIn.getCapability(WaterLevelCapability.PLAYER_WATER_LEVEL).ifPresent(data -> {
                this.canDrink = data.getWaterLevel() < 20;
            });
        }
        return this.canDrink;
    }

    public SoundEvent func_225520_U__() {
        return SoundEvents.field_187664_bz;
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerItemStack(stack, this.capacity){

            @Nonnull
            public ItemStack getContainer() {
                return this.getFluid().isEmpty() ? new ItemStack((IItemProvider)ItemRegistry.LEATHER_WATER_BAG) : this.container;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                for (Fluid fluid : FluidTags.func_226157_a_().func_199910_a(new ResourceLocation("watersource", "drink")).func_230236_b_()) {
                    if (fluid != stack.getFluid()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        ItemStack itemStack1 = itemStack.func_77946_l();
        itemStack1.func_196085_b(this.capacity);
        return itemStack1;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_179543_a("Fluid") != null) {
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(f -> {
                tooltip.add((ITextComponent)((TextComponent)f.getFluidInTank(0).getDisplayName()).func_240702_b_(String.format(": %d / %dmB", f.getFluidInTank(0).getAmount(), this.capacity)).func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.watersource.drink_unit").func_240702_b_(" : " + this.getUnit() + "mB").func_240699_a_(TextFormatting.GRAY));
            });
        }
    }
}

